<?php

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( ! class_exists( 'TC_PTC_Session' ) ) {

    class TC_PTC_Session {

        private $prefix = 'tc_ptc_';

        /**
         * Set Sessions via Cookie
         *
         * @param $content
         * @param string $type
         */
        function set( $content, $type = 'error' ) {

            ob_start();
            $cookie_id = $this->prefix . COOKIEHASH;
            unset( $_COOKIE[ $cookie_id ] );
            setcookie( $cookie_id, '', -1, '/' );

            // Set cookie
            $cookie[ 'content' ] = $content;
            $cookie[ 'type' ] = $type;
            $expire = time() + 60; // 5secs
            setcookie( $cookie_id, json_encode( $cookie ), $expire, COOKIEPATH, COOKIE_DOMAIN );
            $_COOKIE[ $cookie_id ] = json_encode( $cookie );
            ob_end_flush();
        }

        /**
         * Get Sessions from Cookie
         *
         * @return mixed|string
         */
        function get() {
            $cookie_id = $this->prefix . COOKIEHASH;
            return ( isset( $_COOKIE[ $cookie_id ] ) ) ? json_decode( stripslashes( $_COOKIE[ $cookie_id ] ), true ) : false;
        }

        /**
         * Destroy Cookie
         */
        function destroy() {
            ob_start();
            $cookie_id = $this->prefix . COOKIEHASH;
            unset( $_COOKIE[ $cookie_id ] );
            setcookie( $cookie_id,'', -1, '/' );
            ob_end_flush();
        }
    }
}
