<?php

/**
 * Setting stored values
 */
$setting = get_option( 'tc_predefined_ticket_codes_setting' );
$enabled = isset( $setting[ 'enabled' ] ) ? $setting[ 'enabled' ] : 'no';
$stop_sales = isset( $setting[ 'stop_sales' ] ) ? $setting[ 'stop_sales' ] : 'no';

/**
 * Errors
 */
$error = '';
$session = new TC_PTC_Session();
$session = $session->get();

/**
 * Pagination and Search parameters
 */
$per_page = 20;
$page_num = ( isset( $_GET[ 'page_num' ] ) ) ? (int) $_GET[ 'page_num' ] : 1;
$page = sanitize_key( $_GET[ 'page' ] );
$tab = sanitize_key( $_GET[ 'tab' ] );
$search = ( isset( $_GET[ 's' ] ) ) ? sanitize_text_field( $_GET[ 's' ] ) : '';

/**
 * Table Fields
 */
$setting = new TC_PTC_Setting();
$columns = $setting->get_fields();

/**
 * Collection of Ticket Codes
 */
$db = new TC_PTC_DB();
$sort = isset( $_GET[ 'sort' ] ) ? sanitize_key( $_GET[ 'sort' ] ) : 'status';
$sort_by = isset( $_GET[ 'order' ] ) ? sanitize_key( $_GET[ 'order' ] ) : 'desc';
$ticket_codes = ( '' != $search ) ? $db->select( [ 'ticket_code' => $search ], '', '', 'LIKE' ) : $db->select( [], $per_page, $page_num, '=', $sort, $sort_by );

/**
 * Render Pagination
 */
$pagination = new Tickera\TC_Pagination();
$pagination->Items( count( $db->select() ) );
$pagination->limit( $per_page );
$pagination->parameterName = 'page_num';

if ( '' != $search ) {
    $pagination->target( "edit.php?post_type=tc_events&page=tc_settings&tab=tickera_predefined_ticket_codes&s=" . $search );

} else {
    $pagination->target( "edit.php?post_type=tc_events&page=tc_settings&tab=tickera_predefined_ticket_codes" );
}

$pagination->currentPage( $page_num );
$pagination->items_title = __( 'Ticket Codes', 'tc' );
?>
<div class="wrap tc_wrap">
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tickera_save_predefined_ticket_codes" name="tickera_save_predefined_ticket_codes" method="post" enctype="multipart/form-data" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>">
            <input type="hidden" name="action" value="tickera_save_predefined_ticket_codes">
            <div id="store_settings" class="postbox">
                <h3><span><?php _e( 'Settings', 'tc' ); ?></span></h3>
                <div class="inside">
                    <table class="form-table">
                        <tbody>
                        <tr valign="top">
                            <th scope="row"><?php _e( 'Enable', 'tc' ); ?></th>
                            <td>
                                <label><input type="radio" class="" name="enabled_option" value="yes" <?php checked( $enabled, 'yes', true ); ?> /><?php _e( 'Yes', 'tc' ); ?></label>
                                <label><input type="radio" class="" name="enabled_option" value="no" <?php checked( $enabled, 'no', true ); ?> /><?php _e( 'No', 'tc' ); ?></label>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row"><?php _e( 'Stop ticket sales', 'tc' ); ?></th>
                            <td>
                                <label><input type="radio" class="" name="stop_sales_option" value="yes" <?php checked( $stop_sales, 'yes', true ); ?> /><?php _e( 'Yes', 'tc' ); ?></label>
                                <label><input type="radio" class="" name="stop_sales_option" value="no" <?php checked( $stop_sales, 'no', true ); ?> /><?php _e( 'No', 'tc' ); ?></label>
                                <span class="description"><?php echo __( 'Stop ticket sales once all available predefined tickets codes have been used.', 'tc' ); ?></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <p class="submit">
                        <input type="submit" name="tc_save_predefined_ticket_codes" id="tc_save_predefined_ticket_codes" class="button button-primary tc_float_none" value="Save">
                    </p>
                </div><!-- .inside -->

            </div><!-- .postbox -->
        </form>
    </div>
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tickera_import_predefined_ticket_codes" name="tickera_import_predefined_ticket_codes" method="post" enctype="multipart/form-data" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>">
            <input type="hidden" name="action" value="tickera_import_predefined_ticket_codes">
            <div id="store_settings" class="postbox">
                <h3><span><?php _e( 'Import CSV', 'tc' ); ?></span></h3>
                <div class="inside">
                    <span class="description"><?php _e( 'Please make sure to import a UTF-8 encoded CSV.', 'tc' ); ?></span>
                    <table class="form-table">
                        <tbody>
                        <tr valign="top">
                            <th scope="row"><label for="tc_import_predefined_ticket_codes_file"><?php _e( 'CSV File', 'tc' ); ?></label></th>
                            <td>
                                <input type="file" name="tc_import_predefined_ticket_codes_file" />
                                <p>
                                    <a class="tc_link" href="<?php echo plugins_url('../../assets/csv/template.csv', __FILE__ ) ?>" target="_blank"><?php _e('download template file','tc') ?></a>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <?php if ( $session ) : ?>
                        <p class="<?php echo 'tcptc-' . $session[ 'type' ]; ?>"><?php echo esc_html( $session[ 'content' ] ); ?></p>
                    <?php endif; ?>
                    <p class="submit">
                        <input type="submit" name="tc_import_predefined_ticket_codes" id="tc_import_predefined_ticket_codes" class="button button-primary tc_float_none" value="Import">
                    </p>
                </div><!-- .inside -->

            </div><!-- .postbox -->
        </form>
    </div>
    <div id="poststuff" class="metabox-holder tc-ticket-codes">
        <div class="postbox">
            <h3><span><?php _e( 'Ticket Codes', 'tc' ); ?></span>
                <div class="tablenav">
                    <div class="alignright actions new-actions">
                        <form method="get" action="?page=<?php echo esc_attr( $page ); ?>" class="search-form">
                            <p class="search-box">
                                <input type='hidden' name='post_type' value='tc_events'/>
                                <input type='hidden' name='page' value='<?php echo esc_attr( $page ); ?>'/>
                                <input type='hidden' name='tab' value='<?php echo esc_attr( $tab ); ?>'/>
                                <label class="screen-reader-text"><?php _e( 'Search ticket codes', 'tc' ); ?>:</label>
                                <input type="text" value="<?php echo esc_attr( $search ); ?>" name="s">
                                <input type="submit" class="button" value="<?php _e( 'Search ticket codes', 'tc' ); ?>">
                            </p>
                        </form>
                        <span class="dashicons dashicons-image-rotate tcptc-action tcptc-sync"></span>
                        <span class="tcptc-separator"></span>
                        <span class="dashicons dashicons-trash tcptc-action tcptc-bulk-delete"></span>
                    </div> <!--/alignright-->
                </div> <!--/tablenav-->
            </h3>
            <table cellspacing="0" class="widefat shadow-table">
                <thead>
                <tr>
                    <?php $n = 1; ?>
                    <?php foreach ( $columns as $column ) : ?>
                        <th data-column="<?php echo esc_attr( $column[ 'name' ] ); ?>"<?php echo ( $column[ 'sortable' ] ? " data-order='" . ( isset( $_GET[ 'order' ] ) ? esc_attr( $_GET[ 'order' ] ) : 'desc' ) . "' " : '' ); ?>class="manage-column column-<?php echo esc_attr( $column[ 'name' ] ); ?><?php echo ( $column[ 'sortable' ] ? ' sortable' : '' ) ?>" width="<?php echo( isset( $col_sizes[ $n ] ) ? esc_attr( $col_sizes[ $n ] . '%' ) : '' ); ?>" id="<?php echo esc_attr( $column[ 'name' ] ); ?>" scope="col"><?php echo esc_attr( $column[ 'title' ] ); ?><?php echo ( $column[ 'sortable' ] ? ' <span class="dashicons dashicons-sort"></span>' : '' ); ?></th>
                        <?php $n++; ?>
                    <?php endforeach; ?>
                </tr>
                </thead>
                <tbody>
                <?php if ( ! isset( $ticket_codes[ 'error' ] ) ) :
                    foreach ( $ticket_codes as $values ) : ?>
                        <tr data-id="<?php echo esc_attr( $values->id ); ?>" data-code="<?php echo esc_attr( $values->ticket_code ); ?>">
                            <?php foreach ( $values as $column => $value ) : ?>
                                <?php if ( 'status' == $column ) : ?>
                                    <td class="<?php echo esc_attr( $column ); ?>"><?php echo esc_html( ( $value ) ? __( 'available', 'tc' ) : __( 'used', 'tc' ) ); ?></td>
                                <?php else : ?>
                                    <td class="<?php echo esc_attr( $column ); ?>"><?php echo esc_html( $value ); ?></td>
                                <?php endif; ?>
                            <?php endforeach; ?>
                            <td>
                                <?php if ( $values->status ) : ?>
                                    <span class="dashicons dashicons-edit-page tcptc-action tcptc-edit"></span>
                                    <span class="dashicons dashicons-trash tcptc-action tcptc-trash"></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if ( ! $ticket_codes ) : ?>
                        <tr>
                            <td colspan="6">
                                <div class="zero-records"><?php _e( 'No ticket codes found.', 'tc' ) ?></div>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php else : ?>
                    <tr align="center"><td><?php _e( $ticket_codes[ 'error' ], 'tc' ) ?></td></tr>
                <?php endif; ?>
                </tbody>
            </table> <!--/widefat shadow-table-->
            <span class="tcptc-loader"><span class="tcptc-loader-inner"></span></span>
        </div> <!-- .postbox -->
        <div class="tablenav">
            <div class="tablenav-pages"><?php esc_html( $pagination->show() ); ?></div>
        </div> <!--/tablenav-->
    </div>
</div>
