( function ( $ ) {

    /**
     * Delete Pre-defined Ticket Code
     */
    $( document ).on( 'click', '.tcptc-trash', function() {

        let container = $( this ).closest( 'tr' ),
            ticketCodeId = container.data( 'id' ),
            confirmed = confirm( tc_ptc.trashConfirmationMessage );

        if ( confirmed ) {
            tcptc.delete( ticketCodeId );
            tcptc.show( container, false, true )
        }
    });

    /**
     * Edit Pre-defined Ticket Code
     */
    $( document ).on( 'click', '.tcptc-edit', function() {

        let container = $( this ).closest( 'tr' ),
            actionColumn = container.find( 'td:last-child' );

        // Show edit action buttons
        actionColumn.find( '.tcptc-action' ).hide();
        actionColumn.append( '<div class="tcptc-sub-action"><span class="tcptc-save">' + tc_ptc.save + '</span>|<span class="tcptc-cancel">' + tc_ptc.cancel + '</span></div>' );

        // Edit Ticket Code
        let ticketCodeField = container.find( '.ticket_code' ),
            ticketCodeValue = container.attr( 'data-code' );
        ticketCodeField.empty().append( '<input type="text" id="tcptc-edit-ticket-code" value="' + ticketCodeValue + '"/>' );
    });

    /**
     * Save changes
     */
    $( document ).on( 'click', '.tcptc-save', function() {

        $( this ).closest( 'td' ).find( '.tcptc-sub-action' ).hide();

        let container = $( this ).closest( 'tr' ),
            ticketCodeId = container.data( 'id' ),
            ticketCode = container.data( 'data-code' ),
            ticketCodeInputValue = container.find( '#tcptc-edit-ticket-code' ).val();

        if ( ticketCodeInputValue != ticketCode ) {
            tcptc.post( 'update', {
                'ticket_code_id': ticketCodeId,
                'ticket_code': ticketCodeInputValue
            }, container );

            container.find( '.ticket_code' ).html( ticketCodeInputValue );

        } else {
            $( this ).closest( 'td' ).find( '.tcptc-sub-action' ).show();
        }
    });

    /**
     * Cancel edit
     */
    $( document ).on( 'click', '.tcptc-cancel', function() {

        let container = $( this ).closest( 'tr' );

        // Revert values
        tcptc.revertFieldValues( container );

        // Show edit button
        container.find( '.tcptc-sub-action' ).remove();
        container.find( '.tcptc-action' ).show();
    });
    /**
     * Sync Ticket Codes
     */
    $( document ).on( 'click', '.tcptc-sync', function() {
        tcptc.show( $( this ), false );
        let container = $( this ).closest( '#poststuff' );
        container.addClass( 'tcptc-syncing' );
        tcptc.post( 'sync', '', container );
    });

    /**
     * Bulk Delete Ticket Codes
     */
    $( document ).on( 'click', '.tcptc-bulk-delete', function() {
        let confirmAction = confirm( tc_ptc.confirm_bulk_delete_message );
        if ( confirmAction ) {
            tcptc.show( $( this ), false );
            let container = $( this ).closest( '#poststuff' );
            container.addClass( 'tcptc-syncing' );
            tcptc.post( 'bulk_delete', '', container );
        }
    });

    /**
     * Sortable Column
     */
    $( document ).on( 'click', '.tc-ticket-codes .sortable', function() {

        let column = $( this ).data( 'column' ),
            sort = $( this ).data( 'order' );

        tcptc.post( 'sort', {
            'sort': column,
            'order': sort
        }, '' );
    } )

    const tcptc = {

        actionSpan: '<span class="dashicons dashicons-edit-page tcptc-action tcptc-edit"></span><span class="dashicons dashicons-trash tcptc-action tcptc-trash"></span>',

        delete: function( ticketCodeId ) {
            let container = $( 'tr[data-id="' + ticketCodeId + '"]' );
            tcptc.post( 'delete', {
                'ticket_code_id': ticketCodeId
            }, container);
        },

        post: function( postAction, postData, element ) {

            $.post( tc_ptc.ajaxUrl, { action: 'tickera_predefined_ticket_code_' + postAction + '_action', postData } )
                .done( function( response ) {

                    if ( response.success ) {
                        tcptc.nextPostAction( element, postAction, response );

                    } else if ( typeof response.error !== 'undefined' ) {
                        alert( response.error );
                        tcptc.revertPostAction( element, postAction );

                    } else {
                        alert( tc_ptc.queryFailed );
                        tcptc.revertPostAction( element, postAction );
                    }

                })
                .fail( function( xhr, status, error ) {
                    alert( xhr.responseText )
                    tcptc.revertPostAction( element, postAction );
                })
        },

        nextPostAction: function ( element, postAction, response ) {

            switch ( postAction ) {

                case 'update':
                    let ticketCode = element.find( '.ticket_code' ).html();
                    element.attr( 'data-code', ticketCode );
                    element.find( '.tcptc-sub-action' ).remove();
                    element.find( '.tcptc-action' ).show();
                    break;

                case 'delete':
                    element.remove();
                    break;

                case 'bulk_delete':
                    element.removeClass( 'tcptc-syncing' );
                    let bulkDeleteBtn = element.find( '.tcptc-bulk-delete' );
                    tcptc.show( bulkDeleteBtn, true );
                    location.reload();
                    break;

                case 'sync':
                    let syncBtn = element.find( '.tcptc-sync' );

                    if ( ! response.complete ) {

                        tcptc.post( 'sync', { 'page': response.page }, element )

                        // Update ticket codes status to "used"
                        response.ticket_codes.used.forEach( function( item, index ){
                            let container = element.find( 'tr[data-code="' + item + '"]' );
                            container.find( 'td.status' ).html( tc_ptc.used );
                            container.find( 'td:last' ).empty();
                        });

                        // Update ticket codes status to "available"
                        response.ticket_codes.available.forEach( function( item, index ){
                            let container = element.find( 'tr[data-code="' + item + '"]' );
                            container.find( 'td.status' ).html( tc_ptc.available );
                            container.find( 'td:last' ).html( tcptc.actionSpan );
                        });

                    } else {
                        element.removeClass( 'tcptc-syncing' );
                        tcptc.show( syncBtn, true );
                    }
                    break;

                case 'sort':
                    let url = window.location.href;
                    for ( let key in response ) {
                        if ( 'success' != key )
                            url += '&' + key + '=' + encodeURIComponent( response[ key ] );
                    }
                    window.location.replace( url )
                    break;
            }
        },

        revertPostAction: function( element, postAction ) {

            switch ( postAction ) {

                case 'update':
                    // Revert row data
                    tcptc.revertFieldValues( element );

                    // Show edit button
                    element.find( '.tcptc-sub-action' ).remove();
                    element.find( '.tcptc-action' ).show();
                    break;

                case 'delete':
                    tcptc.show( element, true, true );
                    break;

                case 'sync':
                    let syncBtn = element.find( '.tcptc-sync' );
                    element.removeClass( 'tcptc-syncing' );
                    tcptc.show( syncBtn, true );
                    break;
            }
        },

        revertFieldValues: function ( container ) {
            let ticketCode = container.attr( 'data-code' );
            container.find( '.ticket_code' ).html( ticketCode );
        },

        show: function( element, show, force ) {

            if ( true == show ) {
                let show = ( typeof force === 'undefined' ) ? false : force;
                if ( true == show ) { element.show(); }
                element.removeClass( 'tcptc-hidden' ).addClass( 'tcptc-show' );

            } else {
                let hide = ( typeof force === 'undefined' ) ? false : force;
                element.removeClass( 'tcptc-show' ).addClass( 'tcptc-hidden' );
                if ( true == hide ) { setTimeout( function() { element.hide(); }, 300 ); }
            }
        }
    };

})( jQuery );
